<?php
defined('BASEPATH') OR exit('No direct script access allowed');

class Sliders extends CI_Controller {
	public function __construct()
	{
		parent::__construct();
		$this->load->model('Common');
		$this->load->model('android/M_home','home');
	}
	public function index()
	{   
	    $latitude    = $this->security->xss_clean($this->input->get('latitude'));
	    $longitude   = $this->security->xss_clean($this->input->get('longitude'));
	    
	    $radius    = $this->Common->get_details('delivery_area',array())->row()->area_distance;
	    $radius    = $radius/1.609;
	    
		$sliders  = $this->Common->get_details('banners',array('status'=>'1'));
		if($sliders->num_rows() > 0)
		{  
		    $rest         = $this->home->getRestaurantSliders($latitude,$longitude,$radius);
		    foreach($rest as $re)
		    {
		        $re->branch_id = '0';
		    }
		    $branches     = $this->home->getBranchSliders($latitude,$longitude,$radius);
		    $array        = array_merge($rest, $branches);
		    
    		function array_multi_subsort($array, $subkey)
            {
                $b = array(); $c = array();
            
                foreach ($array as $k => $v)
                {
                    $b[$k] = strtolower($v->$subkey);
                }
            
                asort($b);
                foreach ($b as $key => $val)
                {
                    $c[] = $array[$key];
                }
            
                return $c;
            }

            $result = array_multi_subsort($array, 'distance');    
		  //  $result   = $this->home->getSliders($latitude,$longitude,$radius);
	    	$return   = [
        				   'status'  => true,
        				   'data'    => $result
        				];
		
		}
		else 
		{
			$return = [
        				'status' => false,
        				'data'   => array()
        			   ];
		}
		print_r(json_encode($return));
	}

}
?>
