<?php
defined('BASEPATH') OR exit('No direct script access allowed');

class Restaurant extends CI_Controller {
	public function __construct()
	{
		parent::__construct();
		$this->load->model('Common');
		$this->load->model('android/M_restaurant','rest');
		$this->load->model('android/M_home','home');
	}
	
	public function index()
	{    
	    $latitude    = $this->security->xss_clean($this->input->post('latitude'));
	    $longitude   = $this->security->xss_clean($this->input->post('longitude'));
	    
	    $radius    = $this->Common->get_details('delivery_area',array())->row()->area_distance;
	    $radius    = $radius/1.609;
	     
	    $cuisine_id      = $this->security->xss_clean($this->input->post('cuisine_id'));
	    if($cuisine_id=='0')
	    {
	        $check           = $this->Common->get_details('restaurants',array('status'=>'1'));
    		if($check->num_rows()>0)
    		{
    		  //  $restaurants  = $this->rest->getRestaurants();
    		    $rest         = $this->rest->getRestaurants($latitude,$longitude,$radius);
    		    foreach($rest as $re)
    		    {
    		        $re->branch_id = '0';
    		    }
    		    $branches     = $this->rest->getBranches($latitude,$longitude,$radius);
    		    $array        = array_merge($rest, $branches);
                
                function array_multi_subsort($array, $subkey)
                    {
                        $b = array(); $c = array();
                    
                        foreach ($array as $k => $v)
                        {
                            $b[$k] = strtolower($v->$subkey);
                        }
                    
                        asort($b);
                        foreach ($b as $key => $val)
                        {
                            $c[] = $array[$key];
                        }
                    
                        return $c;
                    }

                $restaurants = array_multi_subsort($array, 'distance');

    		    foreach($restaurants as $restaurant)
    		    {
    		         $restaurant->types  = $this->rest->getTypes($restaurant->r_id);
    		         $restaurant->ratings= '0';
    		         $restaurant->sale_value = '0';
    		         $restaurant->coupons   = $this->home->getCoupons($restaurant->r_id);
			         $restaurant->promotions= $this->home->getPromotions($restaurant->r_id);
			         if($restaurant->latitude!='' || $restaurant->longitude!='')
			         {
			             $distance              = $this->GetDrivingDistance($latitude, $restaurant->latitude, $longitude, $restaurant->longitude);
                         $town_distance         = $distance['distance'];
                         $town_time_taken       = $distance['time'];
                         $restaurant->travel_time      = $town_time_taken;
                         $restaurant->travel_distance  = $town_distance;
			         }
			         else
			         {
			              $restaurant->travel_time       = 0;
			              $restaurant->travel_distance  = 0;
			         }
    		    }       
    		}
    		else
    		{
    		    $restaurants  = array();
    		}
	    }
	    else
	    {
	        $check           = $this->rest->getCuisineRestaurantsCount($cuisine_id,$latitude,$longitude,$radius);
	       // $check           = $this->rest->getCuisineRestaurants($cuisine_id);
    		if($check>0)
    		{
    		    $rest        = $this->rest->getCuisineRestaurants($cuisine_id,$latitude,$longitude,$radius);
    		    foreach($rest as $re)
    		    {
    		        $re->branch_id = '0';
    		    }
    		    $branches     = $this->rest->getCuisineBranches($cuisine_id,$latitude,$longitude,$radius);
    		    $array        = array_merge($rest, $branches);
    		     
    		    function array_multi_subsort($array, $subkey)
                {
                    $b = array(); $c = array();
                
                    foreach ($array as $k => $v)
                    {
                        $b[$k] = strtolower($v->$subkey);
                    }
                
                    asort($b);
                    foreach ($b as $key => $val)
                    {
                        $c[] = $array[$key];
                    }
                
                    return $c;
                }

                $restaurants = array_multi_subsort($array, 'distance');
    		    
    		    foreach($restaurants as $restaurant)
    		    {
    		         $restaurant->types = $this->rest->getTypes($restaurant->r_id);
    		         $restaurant->ratings= '0';
    		         $restaurant->sale_value = '0'; 
    		         $restaurant->coupons   = $this->home->getCoupons($restaurant->r_id);
			         $restaurant->promotions= $this->home->getPromotions($restaurant->r_id);
			         if($restaurant->latitude!='' || $restaurant->longitude!='')
			         {
			             $distance                          = $this->GetDrivingDistance($latitude, $restaurant->latitude, $longitude, $restaurant->longitude);
                         $town_distance                     = $distance['distance'];
                         $town_time_taken                   = $distance['time'];
                         $restaurant->travel_time           = $town_time_taken;
                         $restaurant->travel_distance       = $town_distance;
			         }
			         else
			         {
			             $restaurant->travel_time           = 0;
			             $restaurant->travel_distance       = 0;
			         }
    		    }       
    		}
    		else
    		{
    		    $restaurants  = array();
    		}
	    }
	   
        $return      =  [
                          'status'  => true,
                          'data'    => $restaurants,
                       ];
		        
		print_r(json_encode($return));
	}
	
	public function search()
	{
	    $key         = $this->security->xss_clean($this->input->post('key'));
		$keyword     = str_replace(" ", "%", $key);
		if($keyword=='')
		{     
		      $rest        = $this->rest->getAllRestaurants();
		      foreach($rest as $re)
		      {
		          $re->branch_id = '0';
		      }
		      $branch      = $this->rest->getAllBranches();
		      $array        = array_merge($rest, $branch);
    		     
    		    function array_multi_subsort($array, $subkey)
                    {
                        $b = array(); $c = array();
                    
                        foreach ($array as $k => $v)
                        {
                            $b[$k] = strtolower($v->$subkey);
                        }
                    
                        asort($b);
                        foreach ($b as $key => $val)
                        {
                            $c[] = $array[$key];
                        }
                    
                        return $c;
                    }

             $restaurants = array_multi_subsort($array, 'r_id');
		}
		else
		{    
		     $rest        = $this->rest->searchRestaurant($keyword);
		     foreach($rest as $re)
		      {
		          $re->branch_id = '0';
		      }
		   	 $branch     = $this->rest->searchBranches($keyword);
		   	 $array       = array_merge($rest, $branch);
    		     
    		    function array_multi_subsort($array, $subkey)
                    {
                        $b = array(); $c = array();
                    
                        foreach ($array as $k => $v)
                        {
                            $b[$k] = strtolower($v->$subkey);
                        }
                    
                        asort($b);
                        foreach ($b as $key => $val)
                        {
                            $c[] = $array[$key];
                        }
                    
                        return $c;
                    }

             $restaurants = array_multi_subsort($array, 'r_id');
 
		}
        $return      =  [
                          'status'  => true,
                          'data'    => $restaurants
                       ];
		        
		print_r(json_encode($return));
	}
	
	public function details()
	{   
	    date_default_timezone_set('Asia/Kolkata');
		$date       = date('Y-m-d');
	    $time       = date('H:i:s');
	    $current    = date('Y-m-d H:i:s');
	    
	    $restaurant_id   = $this->security->xss_clean($this->input->post('restaurant_id'));
	    $branch_id       = $this->security->xss_clean($this->input->post('branch_id'));
		$check           = $this->Common->get_details('restaurants',array('r_id'=>$restaurant_id));
		if($check->num_rows()>0)
		{
		    
		    if($branch_id=='0')
		    {
		        $restaurant        = $check->row();
		        $restaurant->branch_id     = '0';
		        $restaurant->delivery_time = '30';
		        $restaurant->reviews= $this->Common->get_details('restaurant_reviews',array('r_id'=>$restaurant_id))->num_rows();
    		    $total_rating       = $this->rest->totalRatings($restaurant_id);
    		  //  $restaurant->ratings= $total_rating/$restaurant->reviews;
    		    if($restaurant->reviews>0)
    		    {
    		        $restaurant->ratings = '4';
    		    }
    		    else
    		    {
    		        $restaurant->ratings = '0';
    		    }
    		    $restaurant->min_order = $restaurant->min_order;
    		    $restaurant->delivery_fee = '0';
    		    $restaurant->sales_tax = '0';
    		    $restaurant->service_charge = $restaurant->service_charge;
    		    $restaurant->types     = $this->rest->getTypes($restaurant_id);
    		    $restaurant->coupons   = $this->home->getCoupons($restaurant_id);
    			$restaurant->promotions= $this->home->getPromotions($restaurant_id);
		    }
		    else
		    {
		        $details          = $check->row();
		        $branch           = $this->Common->get_details('branches',array('b_id'=>$branch_id))->row();
		        $restaurant       = [
		                                'r_id'         => $details->r_id,
		                                'branch_id'    => $branch_id,
		                                'rest_name'    => $details->rest_name,
		                                'rest_email'   => $branch->email,
		                                'rest_phone'   => $branch->phone,
		                                'rest_image'   => $details->rest_image,
		                                'cover_image'  => $details->cover_image,
		                                'latitude'     => $branch->latitude,
		                                'longitude'    => $branch->longitude,
		                                'address1'     => $branch->address,
		                                'landmark'     => $branch->location,
		                                'open_time'    => $details->open_time,
		                                'close_time'   => $details->close_time,
		                                'delivery_time'=> '30',
		                                'min_order'    => $details->min_order,
		                                'service_charge'=>$details->service_charge,
		                                'city'         => $details->city
		                            ];
	            $restaurant['reviews']= $this->Common->get_details('restaurant_reviews',array('r_id'=>$restaurant_id))->num_rows();
    		    $total_rating         = $this->rest->totalRatings($restaurant_id);
    		  //  $restaurant->ratings= $total_rating/$restaurant->reviews;
    		    if($restaurant['reviews']>0)
    		    {
    		        $restaurant['ratings'] = '4';
    		    }
    		    else
    		    {
    		        $restaurant['ratings'] = '0';
    		    }
    		    $restaurant['delivery_fee']= '0';
    		    $restaurant['sales_tax']   = '0';
    		    $restaurant['types']       = $this->rest->getTypes($restaurant_id);
    		    $restaurant['coupons']     = $this->home->getCoupons($restaurant_id);
    			$restaurant['promotions']  = $this->home->getPromotions($restaurant_id);	                            
		    }
		    
		   
			
			$c_check  = $this->Common->get_details('menu',array('r_id'=>$restaurant_id));
    		if($c_check->num_rows()>0)
    		{
    		    $categories  = $c_check->result();
    		    foreach($categories as $cat)
    		    {
    		       $p_check  = $this->Common->get_details('products',array('cat_id'=>$cat->menu_id,'status'=>'active'));
    		       if($p_check->num_rows()>0)
    		       {
    		           $cat->products = $p_check->result();
    		           foreach($cat->products as $product)
            		    {
            		      $product->available_days = $this->rest->getDays($product->p_id);
            		      $offerCheck = $this->rest->checkProductOffer($product->p_id,$date);
            		      if($offerCheck->num_rows()>0)
            		      {
            		          $offer      = $offerCheck->row();
            		          $percentage = $offer->percentage;
            		          $price      = $product->price*$percentage/100;
            		          $product->offer_price      = number_format($product->price-$price,'2');
            		          $product->offer_percentage = $percentage;
            		      }
            		      else
            		      {
            		           $product->offer_price     = '';
            		           $product->offer_percentage= '';
            		      }
            		    }    
    		       }
    		       else
    		       {
    		           $cat->products = array();
    		       }
    		    }
    		}
    		else
    		{
    		    $categories  = array();
    		}
    		
    		 $bestSellingProducts   = $this->rest->getBestSellingProducts($restaurant_id);
    		 foreach($bestSellingProducts as $best)
    		 {
    		      $offerCheck = $this->rest->checkProductOffer($best->p_id,$date);
    		      if($offerCheck->num_rows()>0)
    		      {
    		          $offer      = $offerCheck->row();
    		          $percentage = $offer->percentage;
    		          $price      = $best->price*$percentage/100;
    		          $best->offer_price      = number_format($best->price-$price,'2');
    		          $best->offer_percentage = $percentage;
    		      }
    		      else
    		      {
    		           $best->offer_price     = '';
    		           $best->offer_percentage= '';
    		      }
    		 }
    	     $best_selling          = [
    	                                'menu_id'  => '0',
    	                                'r_id'     => $restaurant_id,
    	                                'name'     => 'Most Selling',
    	                                'status'   => '1',
    	                                'products' => $bestSellingProducts
    	                             ];
    	                             
    	     $return               =  [
                                          'status'  => true,
                                          'data'    => [
                                                          'restaurant'  => $restaurant,
                                                          'category'     => $categories,
                                                          'best_selling' => $best_selling
                                                       ]
                                       ];
		                                  
		}
		else
		{
		    $return                 =  [
                                          'status'  => false,
                                          'data'    => array()
                                       ];
		}
       
		print_r(json_encode($return));
	}
	
	public function categories()
	{
	    $restaurant_id   = $this->security->xss_clean($this->input->post('restaurant_id'));
		$check           = $this->Common->get_details('menu',array('r_id'=>$restaurant_id));
		if($check->num_rows()>0)
		{
		    $categories  = $check->result();
		}
		else
		{
		    $categories  = array();
		}
        $return      =  [
                          'status'  => true,
                          'data'    => $categories
                       ];
		        
		print_r(json_encode($return));
	}
	
	public function products()
	{
	    $cat_id          = $this->security->xss_clean($this->input->post('category_id'));
		$check           = $this->Common->get_details('products',array('cat_id'=>$cat_id));
		if($check->num_rows()>0)
		{
		    $products   = $check->result();
		    foreach($products as $product)
		    {
		      $product->images         = '';  
		      $product->available_days = $this->rest->getDays($product->p_id);
		    }    
		}
		else
		{
		    $products  = array();
		}
        $return      =  [
                          'status'  => true,
                          'data'    => $products
                       ];
		        
		print_r(json_encode($return));
	}
	
	public function getCategories()
	{
	    $restaurant_id   = $this->security->xss_clean($this->input->post('restaurant_id'));
		$check           = $this->Common->get_details('menu',array('r_id'=>$restaurant_id));
		if($check->num_rows()>0)
		{
		    $categories  = $check->result();
		    foreach($categories as $cat)
		    {
		       $p_check  = $this->Common->get_details('products',array('cat_id'=>$cat->menu_id,'status'=>'active'));
		       if($p_check->num_rows()>0)
		       {
		           $cat->products = $p_check->num_rows();
		       }
		       else
		       {
		           $cat->products = '0';
		       }
		    }
		}
		else
		{
		    $categories  = array();
		}
        $return      =  [
                          'status'  => true,
                          'data'    => $categories
                       ];
		        
		print_r(json_encode($return));
	}
    
    public function getCategoryProducts()
	{   
	    date_default_timezone_set('Asia/Kolkata');
		$date       = date('Y-m-d');
	    $time       = date('H:i:s');
	    $current    = date('Y-m-d H:i:s');
		
	    $restaurant_id   = $this->security->xss_clean($this->input->post('restaurant_id'));
		$check           = $this->Common->get_details('menu',array('r_id'=>$restaurant_id));
		if($check->num_rows()>0)
		{
		    $categories  = $check->result();
		    foreach($categories as $cat)
		    {
		       $p_check  = $this->Common->get_details('products',array('cat_id'=>$cat->menu_id,'status'=>'active'));
		       if($p_check->num_rows()>0)
		       {
		           $cat->products = $p_check->result();
		           foreach($cat->products as $product)
        		    {
        		      $product->available_days = $this->rest->getDays($product->p_id);
        		      $offerCheck = $this->rest->checkProductOffer($product->p_id,$date);
        		      if($offerCheck->num_rows()>0)
        		      {
        		          $offer      = $offerCheck->row();
        		          $percentage = $offer->percentage;
        		          $price      = $product->price*$percentage/100;
        		          $product->offer_price      = number_format($product->price-$price,'2');
        		          $product->offer_percentage = $percentage;
        		      }
        		      else
        		      {
        		           $product->offer_price     = '';
        		           $product->offer_percentage= '';
        		      }
        		    }    
		       }
		       else
		       {
		           $cat->products = array();
		       }
		    }
		    
		   
		}
		else
		{
		    $categories  = array();
		}
		
		 $bestSellingProducts   = $this->rest->getBestSellingProducts($restaurant_id);
		 foreach($bestSellingProducts as $best)
		 {
		      $offerCheck = $this->rest->checkProductOffer($best->p_id,$date);
		      if($offerCheck->num_rows()>0)
		      {
		          $offer      = $offerCheck->row();
		          $percentage = $offer->percentage;
		          $price      = $best->price*$percentage/100;
		          $best->offer_price      = number_format($best->price-$price,'2');
		          $best->offer_percentage = $percentage;
		      }
		      else
		      {
		           $best->offer_price     = '';
		           $best->offer_percentage= '';
		      }
		 }
	     $best_selling          = [
	                                'menu_id'  => '0',
	                                'r_id'     => $restaurant_id,
	                                'name'     => 'Most Selling',
	                                'status'   => '1',
	                                'products' => $bestSellingProducts
	                             ];
		
        $return      =  [
                          'status'  => true,
                          'data'    => [
                                          'category'     => $categories,
                                          'best_selling' => $best_selling
                                       ]   
                       ];
		        
		print_r(json_encode($return));
	}
	
	//******************************************************************* GET DRIVING DISTANCE ************************************************************************//	
	function GetDrivingDistance($lat1, $lat2, $long1,$long2)
    {
        $url = "https://maps.googleapis.com/maps/api/distancematrix/json?origins=".$lat1.",".$long1."&destinations=".$lat2."%2C".$long2."&mode=driving&language=pl-PL&key=AIzaSyBCN42iAP4i3_QUcP9HRALRmCuZtA1iLEM";
        $ch = curl_init();
        curl_setopt($ch, CURLOPT_URL, $url);
        curl_setopt($ch, CURLOPT_RETURNTRANSFER, 1);
        curl_setopt($ch, CURLOPT_PROXYPORT, 3128);
        curl_setopt($ch, CURLOPT_SSL_VERIFYHOST, 0);
        curl_setopt($ch, CURLOPT_SSL_VERIFYPEER, 0);
        $response = curl_exec($ch);
        curl_close($ch);
        $response_a = json_decode($response, true);
        $dist = $response_a['rows'][0]['elements'][0]['distance']['text'];
        $time = $response_a['rows'][0]['elements'][0]['duration']['text'];
    
        return array('distance' => $dist, 'time' => $time);
        // return $response_a;
    }

	
}
?>
