<?php
defined('BASEPATH') OR exit('No direct script access allowed');

class Register extends CI_Controller {
	public function __construct()
	{
			parent::__construct();
			$this->load->model('Common');
	}
	
    public function index()
	{   
	    date_default_timezone_set("Asia/Calcutta");
	    $timestamp = date('Y-m-d H:i:s');
	    
		$emailCheck  = true;
		$mobileCheck = true;

		$firstname= $this->security->xss_clean($this->input->post('firstname'));
		$lastname = $this->security->xss_clean($this->input->post('lastname'));
		$email    = $this->security->xss_clean($this->input->post('email'));
		$password = $this->security->xss_clean($this->input->post('password'));
		$mobile   = $this->security->xss_clean($this->input->post('mobile'));
		$fcm      = $this->security->xss_clean($this->input->post('fcm'));
        $auth     = $this->getKey();
        
        $data     =  [
            			'firstname'        => $firstname,
            			'lastname'         => $lastname,
            			'password'         => md5($password),
            			'mobile'           => $mobile,
            			'email'            => $email,
            			'status'           => '1',
            			'auth'             => $auth,
            			'date'             => date('Y-m-d'),
            			'fcm'              => $fcm,
            			'timestamp'        => $timestamp
    		         ];

		$checkMobile = $this->Common->get_details('users',array('mobile' => $mobile))->num_rows();
		$checkEmail  = $this->Common->get_details('users',array('email' => $email))->num_rows();
		if ( $checkMobile > 0 ) 
		{
			$mobileCheck = false;
		}
		if ( $checkEmail > 0 ) 
		{
			$emailCheck = false;
		}
		if($mobileCheck && $emailCheck)
		{
		    if ($id = $this->Common->insert('users',$data)) 
		    {
        		  $return = [
            				   'message' => 'success',
            				   'mobile'  => $mobileCheck,
            				   'email'   => $emailCheck,
            				   'data'    => [
            				                  'user_id'    => $id,
            				                  'first_name' => $firstname,
            				                  'lastname'   => $lastname,
            				                  'email'      => $email,
            				                  'phone'      => $mobile,
            				                  'auth'       => $auth
            				                ]
            				];
			}
			else 
			{
				$return = [
        					'message' => 'failed',
        					'mobile'  => $mobileCheck,
        					'email'   => $emailCheck,
        					'data'    => []
        				  ];
			}
		}
		else 
		{
			   $return = [
            				'message' => 'failed',
            				'mobile'  => $mobileCheck,
            				'email'   => $emailCheck,
            				'data'    => []
            			 ];
		}
		print_r(json_encode($return));
	}
	
	function getKey() 
	{
        while (true) {
            $key = $this->key();
            $cond = ['auth' => $key];
            $check = $this->Common->get_details('users', $cond);
            if ($check->num_rows() == 0) {
                break;
            }
        }
        return $key;
    }
    function key() {
        $characters = '0123456789abcdefghijklmnopqrstuvwxyzABCDEFGHIJKLMNOPQRSTUVWXYZ';
        $charactersLength = strlen($characters);
        $randomString = '';
        for ($i = 0;$i < 20;$i++) {
            $randomString.= $characters[rand(0, $charactersLength - 1) ];
        }
        return $randomString;
    }

}
