<?php
defined('BASEPATH') OR exit('No direct script access allowed');

class Rating extends CI_Controller {
	public function __construct()
	{
		parent::__construct();
		$this->load->model('android/M_ratings','rating');
        $this->load->model('Common');
	}
	
	public function addRating()
	{
		$key = $this->security->xss_clean($this->input->post('auth'));
		if ($user_id = getUserId($key)) 
		{
			$restaurant_id = $this->security->xss_clean($this->input->post('restaurant_id'));
// 			$ratings       = $this->security->xss_clean($this->input->post('ratings'));
			$order_packing   = $this->security->xss_clean($this->input->post('order_packing'));
			$quality_of_food = $this->security->xss_clean($this->input->post('quality_of_food'));
			$delivery_time   = $this->security->xss_clean($this->input->post('delivery_time'));
			$value_for_money = $this->security->xss_clean($this->input->post('value_for_money'));
			$comments        = $this->security->xss_clean($this->input->post('comment'));
			$rating          = $order_packing+$quality_of_food+$delivery_time+$value_for_money;
			$total_rating    = $rating/4;
			
			date_default_timezone_set('Asia/Kolkata');
            $timestamp = date('Y-m-d H:i:s');
			
		   $check      = $this->Common->get_details('orders',array('user_id'=>$user_id,'r_id'=>$restaurant_id));
           if($check->num_rows()>0)
           {
	            $review_check = $this->Common->get_details('restaurant_reviews',array('r_id'=>$restaurant_id,'user_id'=>$user_id));
	            if($review_check->num_rows()>0)
	            {   
	                $rate_id = $review_check->row()->rr_id;
	                $array   = [
    	                           'order_packing'  => $order_packing,
    	                           'quality_of_food'=> $quality_of_food,
    	                           'delivery_time'  => $delivery_time,
    	                           'value_for_money'=> $value_for_money,
    							   'rating'         => $total_rating,
    							   'comments'       => $comments,
    							   'timestamp'      => $timestamp
							    ];
				    $this->Common->update('rr_id',$rate_id,'restaurant_reviews',$array);
	            	$return  = [
	            	              'status'   => true,
	            	              'message'  => 'Review updated successfully'
	            	           ];
	            }
	            else
	            {
                    $array  = [
                    	          'user_id'   => $user_id,
                    	          'r_id'      => $restaurant_id,
                    	          'order_packing'  => $order_packing,
	                              'quality_of_food'=> $quality_of_food,
	                              'delivery_time'  => $delivery_time,
	                              'value_for_money'=> $value_for_money,
                    	          'rating'    => $total_rating,
                    	          'comments'  => $comments,
                    	          'date'      => date('Y-m-d'),
                    	          'timestamp' => $timestamp
                              ];
                    $this->Common->insert('restaurant_reviews',$array);

                	$return  = [
                	              'status'   => true,
                	              'message'  => 'Review added successfully'
                	           ];        
	            }
           }
		   else
		   {
		        $return = [
		                      'status' => false,
		                      'message'=> "Sorry! You are not allowed to review this restaurant since you havent't bought anything from here..."
		                  ];
		   }
		}
		else 
		{
			   $return = [
            				'status' => false,
            				'message' => 'Session expired, Login again'
            			];
		}
		print_r(json_encode($return));
	}
	
	public function getRatings()
	{
		$restaurant_id    = $this->security->xss_clean($this->input->post('restaurant_id'));
		$ratings          = $this->Common->get_details('restaurant_reviews',array('r_id'=>$restaurant_id));
        $ratings_no       = $ratings->num_rows(); 
        $restaurant       = $this->Common->get_details('restaurants',array('r_id'=>$restaurant_id))->row();
        $restaurant_name  = $restaurant->rest_name;
        $restaurant_image = $restaurant->cover_image;
        if($ratings->num_rows()>0)    
        {   
        	$rating                   = $this->rating->getTotalRating($restaurant_id);
        	$reviews                  = $this->rating->getReviews($restaurant_id);
        	$total_ratings            = $rating/$ratings_no;
        	
        	$order_package            = $this->rating->getOrderRating($restaurant_id);
        	$order_rating             = $order_package/$ratings_no;
        	
        	$food_quality             = $this->rating->getFoodRating($restaurant_id);
        	$food_rating              = $food_quality/$ratings_no;
        	
        	$delivery_time            = $this->rating->getDeliveryRating($restaurant_id);
        	$delivery_rating          = $delivery_time/$ratings_no;
        	
        	$value_for_money          = $this->rating->getValueRating($restaurant_id);
        	$value_rating             = $value_for_money/$ratings_no;
        }  
        else
        {
        	$total_ratings            = '0';
        	$order_rating             = '0';
        	$food_rating              = '0';
        	$delivery_rating          = '0';
        	$value_rating             = '0';
        	
            $reviews                  = array();
        }
        
        $return    = [
                          'message'   => 'Success',
                          'data'      => [
                                           'restaurant_id'   => $restaurant_id,
                                           'restaurant_name' => $restaurant_name,
                                           'restaurant_image'=> $restaurant_image,
                                           'total_ratings'   => number_format($total_ratings,'1'),
                                           'order_pacaking_rating' => number_format($order_rating,'1'),
                                           'food_quality_rating'   => number_format($food_rating,'1'),
                                           'delivery_time_rating'  => number_format($delivery_rating,'1'),
                                           'value_for_money_rating'=> number_format($value_rating,'1'),
                                           'total_reviews'   => $reviews
                                         ]
                     ];
		
		print_r(json_encode($return));
	}

}
?>
