<?php
defined('BASEPATH') OR exit('No direct script access allowed');

class Profile extends CI_Controller {
	public function __construct()
	{
		parent::__construct();
		$this->load->model('Common');
	}
	public function index()
	{
	    $key = $this->security->xss_clean($this->input->post('auth'));
		if ($user_id = getUserId($key)) 
		{
		    $profile = $this->Common->get_details('users',array('user_id'=>$user_id))->row();
	    	$return = [
        				'status'  => true,
        				'message' => 'Success',
        				'data'    => $profile
        			  ];
		}
		else
		{
			$return = [
        				'status'  => false,
        				'message' => 'Session expired, please try again later',
        				'data'    => array()
        			  ];
		}
		print_r(json_encode($return));
		
	}
	
	public function update()
	{
	    $key = $this->security->xss_clean($this->input->post('auth'));
		if ($user_id = getUserId($key)) 
		{
		    $firstname= $this->security->xss_clean($this->input->post('firstname'));
		    $lastname = $this->security->xss_clean($this->input->post('lastname'));
		    $dob      = $this->security->xss_clean($this->input->post('dob'));
		    $gender   = $this->security->xss_clean($this->input->post('gender'));
			
	        $array  = [ 
	                     'firstname'   => $firstname,
	                     'lastname'    => $lastname,
	                     'dob'         => $dob,
	                     'gender'      => $gender
	                  ];
	        if($this->Common->update('user_id',$user_id,'users',$array))
	        {
	            $return = [
		                      'status'  => true,
		                      'message' => 'Success'
	                      ];
	        }
	        else
	        {
	            $return = [
		                      'status'  => false,
		                      'message' => 'Failed'
	                       ];
	        }
		}
		else
		{
			$return = [
        				'status' => false,
        				'message' => 'Session expired, please try again later'
        			  ];
		}
		print_r(json_encode($return));
	}
	
	public function changeEmail()
	{
	    $key = $this->security->xss_clean($this->input->post('auth'));
		if ($user_id = getUserId($key)) 
		{
		    $current_password = $this->security->xss_clean($this->input->post('password'));
			$check1 = $this->Common->get_details('users',array('user_id' => $user_id , 'password' => md5($current_password)))->num_rows();
			if($check1 > 0)
			{ 
    		    $email      = $this->security->xss_clean($this->input->post('email'));
    		    $check      = $this->Common->get_details('users',array('email'=>$email,'user_id!='=>$user_id));
    		    if($check->num_rows()>0)
    		    {
    		        $return = [
    		                      'status'  => false,
    		                      'message' => 'Email already exists'
    		                  ];
    		    }
    		    else
    		    {
    		        $array  = [
    		                     'email'  => $email
    		                  ];
    		        if($this->Common->update('user_id',$user_id,'users',$array))
    		        {
    		            $return = [
        		                      'status'  => true,
        		                      'message' => 'Success'
    		                      ];
    		        }
    		        else
    		        {
    		            $return = [
        		                      'status'  => false,
        		                      'message' => 'Failed'
    		                       ];
    		        }
    		    }
			}
			else
			{
				$return = [
        					'status'  => false,
        					'message' => 'Incorrect password'
        			   	  ];
			}   
		}
		else
		{
			$return = [
        				'status' => false,
        				'message' => 'Session expired, please try again later'
        			  ];
		}
		print_r(json_encode($return));
	}
    
    public function changePassword()
	{
		$key = $this->security->xss_clean($this->input->post('auth'));
		if ($user_id = getUserId($key)) 
		{
			$current_password = $this->security->xss_clean($this->input->post('current_password'));
			$check = $this->Common->get_details('users',array('user_id' => $user_id , 'password' => md5($current_password)))->num_rows();
			if($check > 0)
			{
			    $password = $this->security->xss_clean($this->input->post('new_password'));
	    		$array    = [
	    		        	    'password' => md5($password)
	    		            ];
	    		$this->Common->update('user_id',$user_id,'users',$array);

				$return = [
        					'status'  => true,
        					'message' => 'Success'
        				  ];
			}
			else
			{
				$return = [
        					'status'  => false,
        					'message' => 'Incorrect password'
        			   	  ];
			}
		}
		else 
		{
			$return = [
        				'status'  => false,
        				'message' => 'Session expired, please try again later'
        		  	  ];
		}
		print_r(json_encode($return));
	}
	
	public function checkEmail()
	{
	    $email      = $this->security->xss_clean($this->input->post('email'));
	    $check      = $this->Common->get_details('users',array('email'=>$email));
	    if($check->num_rows()>0)
	    {
	        $return = [
	                      'status'  => true,
	                      'message' => 'Success'
	                  ];
	    }
	    else
	    {
            $return = [
	                      'status'  => false,
	                      'message' => 'Failed'
                       ];
	    }
		
		print_r(json_encode($return));
	}
	
}
?>
