<?php
defined('BASEPATH') OR exit('No direct script access allowed');

class Products extends CI_Controller {
	public function __construct()
	{
		parent::__construct();
		$this->load->model('Common');
		$this->load->model('android/M_products','products');
		$this->load->model('android/M_restaurant','rest');
	}

	public function search()
	{   
	    date_default_timezone_set('Asia/Kolkata');
		$date       = date('Y-m-d');
	    $time       = date('H:i:s');
	    $current    = date('Y-m-d H:i:s');
	    
	    $rest_id     = $this->security->xss_clean($this->input->post('restaurant_id'));
	    $key         = $this->security->xss_clean($this->input->post('key'));
		$keyword     = str_replace(" ", "%", $key);
		if($key=='')
		{
	        $products    = $this->products->getAllProducts($rest_id);
	        foreach($products as $product)
		    {
		      $offerCheck = $this->rest->checkProductOffer($product->p_id,$date);
		      if($offerCheck->num_rows()>0)
		      {
		          $offer      = $offerCheck->row();
		          $percentage = $offer->percentage;
		          $price      = $product->price*$percentage/100;
		          $product->offer_price      = number_format($product->price-$price,'2');
		          $product->offer_percentage = $percentage;
		      }
		      else
		      {
		           $product->offer_price     = '';
		           $product->offer_percentage= '';
		      }
		    }   
		}
		else
		{
		 	$products    = $this->products->searchProduct($keyword,$rest_id);
		 	foreach($products as $product)
		    {
		      $offerCheck = $this->rest->checkProductOffer($product->p_id,$date);
		      if($offerCheck->num_rows()>0)
		      {
		          $offer      = $offerCheck->row();
		          $percentage = $offer->percentage;
		          $price      = $product->price*$percentage/100;
		          $product->offer_price      = number_format($product->price-$price,'2');
		          $product->offer_percentage = $percentage;
		      }
		      else
		      {
		           $product->offer_price     = '';
		           $product->offer_percentage= '';
		      }
		    }   
		}
		
        $return      =  [
                          'status'  => true,
                          'data'    => $products
                       ];
		        
		print_r(json_encode($return));
	}
	
	public function details()
	{   
	    date_default_timezone_set('Asia/Kolkata');
		$date       = date('Y-m-d');
	    $time       = date('H:i:s');
	    $current    = date('Y-m-d H:i:s');
	    
	    $key = $this->security->xss_clean($this->input->post('auth'));
		if ($user_id = getUserId($key)) 
		{
    	    $product_id   = $this->security->xss_clean($this->input->post('product_id'));
    		$check           = $this->Common->get_details('products',array('p_id'=>$product_id));
    		if($check->num_rows()>0)
    		{
    		    $product  = $check->row();
    		    $product->images         = $this->products->getProductImages($product->p_id);  
    		    $product->available_days = $this->products->getDays($product->p_id);
    		    $product->extras         = $this->products->getProductExtras($product_id);
    		    $fav_check               = $this->Common->get_details('favourites',array('user_id'=>$user_id,'product_id'=>$product_id));
                if($fav_check->num_rows()>0)
                {
                    $favorite            = $fav_check->row();
                    $product->favorite_id= $favorite->fav_id;
                }
                else
                {
                    $product->favorite_id= '';
                }
                
                 $offerCheck = $this->rest->checkProductOffer($product->p_id,$date);
    		      if($offerCheck->num_rows()>0)
    		      {
    		          $offer      = $offerCheck->row();
    		          $percentage = $offer->percentage;
    		          $price      = $product->price*$percentage/100;
    		          $product->offer_price      = number_format($product->price-$price,'2');
    		          $product->offer_percentage = $percentage;
    		      }
    		      else
    		      {
    		           $product->offer_price     = '';
    		           $product->offer_percentage= '';
    		      }
    		}
    		else
    		{
    		    $product  = array();
    		}
		}
		else
		{
		    $product_id   = $this->security->xss_clean($this->input->post('product_id'));
    		$check           = $this->Common->get_details('products',array('p_id'=>$product_id));
    		if($check->num_rows()>0)
    		{
    		    $product  = $check->row();
    		    $product->images         = $this->products->getProductImages($product->p_id);  
    		    $product->available_days = $this->products->getDays($product->p_id);
    		    $product->extras         = $this->products->getProductExtras($product_id);
    		    $product->favorite_id    = '';
    		    
    		      $offerCheck = $this->rest->checkProductOffer($product->p_id,$date);
    		      if($offerCheck->num_rows()>0)
    		      {
    		          $offer      = $offerCheck->row();
    		          $percentage = $offer->percentage;
    		          $price      = $product->price*$percentage/100;
    		          $product->offer_price      = number_format($product->price-$price,'2');
    		          $product->offer_percentage = $percentage;
    		      }
    		      else
    		      {
    		           $product->offer_price     = '';
    		           $product->offer_percentage= '';
    		      }
    		}
    		else
    		{
    		    $product  = array();
    		}
		}
        $return      =  [
                          'status'  => true,
                          'data'    => $product
                       ];
		        
		print_r(json_encode($return));
	}
	
}
?>
