<?php
defined('BASEPATH') OR exit('No direct script access allowed');

class Orders extends CI_Controller {
	public function __construct()
	{
		parent::__construct();
		$this->load->model('Common');
		$this->load->model('android/M_orders','orders');
	}
	public function index()
	{
	    $key = $this->security->xss_clean($this->input->post('auth'));
		if ($user_id = getUserId($key)) 
		{
		    $orders   = $this->orders->getOrders($user_id);
		    foreach($orders as $order)
		    {   
		         $r_check  = $this->Common->get_details('restaurants',array('r_id'=>$order->r_id));
		         if($r_check->num_rows()>0)
		         {   
		             $details          = $r_check->row();
		             $order->rest_name = $details->rest_name;
		             $order->image     = $details->rest_image;
		         }
		         else
		         {
		             $order->rest_name = '';
		             $order->image     = '';
		         }
    		        
		    }
	    	$return = [
        				'status'  => true,
        				'message' => 'Success',
        				'data'    => $orders
        			  ];
		}
		else
		{
			$return = [
        				'status'  => false,
        				'message' => 'Session expired, please try again later',
        				'data'    => array(),
        				'total'   => ''
        			  ];
		}
		print_r(json_encode($return));
		
	}
	
    public function getOrderDetails()
	{
	    $key = $this->security->xss_clean($this->input->post('auth'));
		if ($user_id = getUserId($key)) 
		{
		     $order_id   = $this->security->xss_clean($this->input->post('order_id'));
		     $order      = $this->Common->get_details('orders',array('order_id'=>$order_id))->row();
		    
	         $r_check  = $this->Common->get_details('restaurants',array('r_id'=>$order->r_id));
	         if($r_check->num_rows()>0)
	         {   
	             $order->restaurant= $r_check->row();
	         }
	         else
	         {
	             $order->restaurant= '';
	         }
	         
	         $order->address   = $this->Common->get_details('address',array('address_id'=>$order->address_id))->row();
	         
	         $products         = $this->Common->get_details('ordered_products',array('order_id'=>$order->order_id))->result();
	         foreach($products as $product)
	         {   
	             $p_details             = $this->Common->get_details('products',array('p_id'=>$product->product_id))->row();
	             $product->product_name = $p_details->name;
	             $product->image        = $p_details->cover_image;
	             $extras        = $this->Common->get_details('ordered_extras',array('order_id'=>$order->order_id,'product_id'=>$product->product_id))->result();
	             foreach($extras as $extra)
	             {   
	                 $e_details         = $this->Common->get_details('extras',array('extra_id'=>$extra->extra_id))->row();
	                 $extra->extra_name = $e_details->name;
	                 $extra->image      = $e_details->image;
	             }
	             $product->extras= $extras;
	         }
	         $order->products    = $products;
	         
	    	$return = [
        				'status'  => true,
        				'message' => 'Success',
        				'data'    => $order
        			  ];
		}
		else
		{
			$return = [
        				'status'  => false,
        				'message' => 'Session expired, please try again later',
        				'data'    => array(),
        				'total'   => ''
        			  ];
		}
		print_r(json_encode($return));
		
	}
	
	public function getCancelReasons()
	{
	    $check = $this->Common->get_details('cancel_reasons',array('reason_for'=>'Customer','status'=>'1'));
	    if($check->num_rows()>0)
	    {
	        $reasons = $check->result();
	        $return  = [
	                       'status'  => true,
	                       'data'    => $reasons
 	                   ];
	    }
	    else
	    {
	        $return   = [
	                       'status'  => false,
	                       'data'    => array()
	                    ];
	    }
	    
	    print_r(json_encode($return));
	}
	
	public function cancelOrder()
	{   
	    date_default_timezone_set('Asia/Kolkata');
		$timestamp     = date('Y-m-d H:i:s');
		$date          = date('Y-m-d');
		$time          = date('h:i A');
		
	   	$key = $this->security->xss_clean($this->input->post('auth'));
		if ($user_id = getUserId($key)) 
		{
    	    $order_id   = $this->security->xss_clean($this->input->post('order_id'));
    	    $reason_id  = $this->security->xss_clean($this->input->post('reason_id'));
    	    $comments   = $this->security->xss_clean($this->input->post('comments'));
    	    
    	    $cancel     = [
    	                        'status'         => 'cancelled',
    	                        'cancelled_date' => $date,
    	                        'cancelled_time' => $time
    	                  ];
    	   if($this->Common->update('order_id',$order_id,'orders',$cancel))
    	   {        
    	            $array  = [
    	                         'order_id'      => $order_id,
    	                         'user_id'       => $user_id,
    	                         'cancelled_by'  => 'customer',
    	                         'reason_id'     => $reason_id,
    	                         'cancelled_date'=> $date,
    	                         'cancelled_time'=> $time,
    	                         'comments'      => $comments,
    	                         'timestamp'     => $timestamp
    	                      ];
    	            $this->Common->insert('cancelled_orders',$array); 
    	            
    			    $return = [
    			                 'status'    => true,
    			                 'message'   => 'Success'
    			              ];
    	   }
    	   else
    	   {
    	           $return  = [  
    	                         'status'    => false,
    			                 'message'   => 'Failed'
    			              ];
    	   }
		}
		else
		{
			$return = [
        				'status'  => false,
        				'message' => 'Session expired, please try again later'
        			  ];
		}
		print_r(json_encode($return));
	}
	
}
?>
