<?php
defined('BASEPATH') OR exit('No direct script access allowed');

class Home extends CI_Controller {
	public function __construct()
	{
		parent::__construct();
		$this->load->model('Common');
		$this->load->model('android/M_home','home');
		$this->load->model('android/M_restaurant','rest');
		$this->load->model('android/M_offers','offers');
	}

	public function index()
	{
	    $latitude    = $this->security->xss_clean($this->input->get('latitude'));
	    $longitude   = $this->security->xss_clean($this->input->get('longitude'));
	    
	    $radius    = $this->Common->get_details('delivery_area',array())->row()->area_distance;
	    $radius    = $radius/1.609;
	    
		$sections    = $this->home->getDetails();
		foreach($sections as $section)
		{   
		    if($section->type!='0')
		    {
		        $section->cuisines   = $this->Common->get_details('section_cuisines',array('hs_id'=>$section->hs_id))->result();
				foreach($section->cuisines as $cu)
				{
					$cu->name             = $this->Common->get_details('cuisines',array('c_id'=>$cu->c_id))->row()->name;
				}
				
				$rest                 = $this->home->getRestaurants($section->hs_id,$latitude,$longitude,$radius);
				foreach($rest as $re)
    		    {
    		        $re->branch_id = '0';
    		    }
				$branches             = $this->home->getBranches($section->hs_id,$latitude,$longitude,$radius);
				$array                = array_merge($rest, $branches);
    		     
    		    function array_multi_subsort($array, $subkey)
                    {
                        $b = array(); $c = array();
                    
                        foreach ($array as $k => $v)
                        {
                            $b[$k] = strtolower($v->$subkey);
                        }
                    
                        asort($b);
                        foreach ($b as $key => $val)
                        {
                            $c[] = $array[$key];
                        }
                    
                        return $c;
                    }
                 $section->restaurants = array_multi_subsort($array, 'distance');
				// $section->restaurants = $this->home->getRestaurants($section->hs_id,$latitude,$longitude,$radius);
				// $section->restaurants = $this->home->getRestaurants($section->hs_id);
				foreach($section->restaurants as $restaurants)
				{   
				    $rest                   = $this->Common->get_details('restaurants',array('r_id'=>$restaurants->r_id))->row();
				    $restaurants->rest_name = $rest->rest_name;
				    $restaurants->rest_image= $rest->rest_image;
				    if($restaurants->branch_id=='0')
				    {
				        $restaurants->latittude = $rest->latitude;
				        $restaurants->longitude = $rest->longitude;
				    }
				    else
				    {
				        $branch                  = $this->Common->get_details('branches',array('b_id'=>$restaurants->branch_id))->row();
				        $restaurants->latittude  = $branch->latitude;
				        $restaurants->longitude  = $branch->longitude;
				    }
				    $restaurants-> ratings  = '0'; 
				    $restaurants->min_order = $rest->min_order;
				    $restaurants->service_charge = $rest->service_charge;
				    $restaurants->coupons   = $this->home->getCoupons($restaurants->r_id);
				    $restaurants->promotions= $this->home->getPromotions($restaurants->r_id);
				    $restaurants->types     = $this->rest->getTypes($restaurants->r_id);
				}
		    }
		    else
		    {
		       $section->cuisine = ''; 
		       
		       $rest                 = $this->home->getAllRestaurants($latitude,$longitude,$radius);
				foreach($rest as $re)
    		    {
    		        $re->branch_id = '0';
    		    }
				$branches             = $this->home->getAllBranches($latitude,$longitude,$radius);
				$array                = array_merge($rest, $branches);
    		     
    		        function array_multi_subsort1($array, $subkey)
                    {
                        $b = array(); $c = array();
                    
                        foreach ($array as $k => $v)
                        {
                            $b[$k] = strtolower($v->$subkey);
                        }
                    
                        asort($b);
                        foreach ($b as $key => $val)
                        {
                            $c[] = $array[$key];
                        }
                    
                        return $c;
                    }
                 $section->restaurants = array_multi_subsort1($array, 'distance');
		       
		      // $section->restaurants = $this->home->getAllRestaurants();
		      // $section->restaurants = $this->home->getAllRestaurants($latitude,$longitude,$radius);
		       foreach($section->restaurants as $restaurants)
				{   
				    $rest                   = $this->Common->get_details('restaurants',array('r_id'=>$restaurants->r_id))->row();
				    $restaurants->rest_name = $rest->rest_name;
				    $restaurants->rest_image= $rest->rest_image;
				    if($restaurants->branch_id=='0')
				    {
				        $restaurants->latittude = $rest->latitude;
				        $restaurants->longitude = $rest->longitude;
				    }
				    else
				    {
				        $branch                  = $this->Common->get_details('branches',array('b_id'=>$restaurants->branch_id))->row();
				        $restaurants->latittude  = $branch->latitude;
				        $restaurants->longitude  = $branch->longitude;
				    }
				    $restaurants-> ratings  = '0'; 
				    $restaurants->coupons   = $this->home->getCoupons($restaurants->r_id);
				    $restaurants->promotions= $this->home->getPromotions($restaurants->r_id);
				    $restaurants->types     = $this->rest->getTypes($restaurants->r_id);
				}
		    }
		     
		}
        $return      =  [
                          'status'  => true,
                          'data'    => $sections
                        ];
		        
		print_r(json_encode($return));
	}
	
	public function getOrderStatus()
	{
	    $key = $this->security->xss_clean($this->input->post('auth'));
		if ($user_id = getUserId($key)) 
		{
		    $check  = $this->Common->get_details('orders',array('user_id'=>$user_id));
		    if($check->num_rows()>0)
		    {
		        $order      = $this->home->getOrderStatus($user_id);
		        $restaurant = $this->Common->get_details('restaurants',array('r_id'=>$order->r_id))->row();
		        $order->rest_name = $restaurant->rest_name;
		        $order->rest_image= $restaurant->cover_image;
		        
		        $return      = [
                				'status'  => true,
                				'message' => 'Success',
                				'data'    => $order
                			  ];
		    }
		    else
		    {
		        $return = [
            				'status'  => false,
            				'message' => 'Failed',
            				'data'    => array()
            			  ];
		    }
		}
		else
		{
			$return = [
        				'status'  => false,
        				'message' => 'Session expired, please try again later',
        				'data'    => array()
        			  ];
		}    
        print_r(json_encode($return));
	}

	
}
?>
