<?php
defined('BASEPATH') OR exit('No direct script access allowed');

class Favourites extends CI_Controller {
	public function __construct()
	{
		parent::__construct();
		$this->load->model('android/M_favourites','favourites');
        $this->load->model('Common');
	}
	
	public function add()
	{
		$key = $this->security->xss_clean($this->input->post('auth'));
		if ($user_id = getUserId($key)) 
		{
			$restaurant_id = $this->security->xss_clean($this->input->post('restaurant_id'));
			$branch_id     = $this->security->xss_clean($this->input->post('branch_id'));
            $product_id    = $this->security->xss_clean($this->input->post('product_id')); 
			
			date_default_timezone_set('Asia/Kolkata');
            $timestamp = date('Y-m-d H:i:s');
			
		    $check      = $this->Common->get_details('favourites',array('user_id'=>$user_id,'product_id'=>$product_id));
            if($check->num_rows()=='0')
            {
	            
                    $array  = [
                    	          'user_id'   => $user_id,
                    	          'r_id'      => $restaurant_id,
                    	          'branch_id' => $branch_id,
                    	          'product_id'=> $product_id, 
                    	          'date'      => date('Y-m-d'),
                    	          'timestamp' => $timestamp
                              ];
                    $id=$this->Common->insert('favourites',$array);

                	$return  = [
                	              'status'   => true,
                	              'message'  => 'Success',
                	              'fav_id'   => $id
                	           ];        
	        }
		    else
		    {
		        $return = [
		                      'status' => false,
		                      'message'=> 'Failed',
		                      'fav_id' => ''
		                  ];
		    }
		}		   
		else 
		{
			   $return = [
            				'status' => false,
            				'message' => 'Session expired, Login again',
            				'fav_id'  => ''
            			];
		}
		print_r(json_encode($return));
	}
	
	public function get()
	{
		$key = $this->security->xss_clean($this->input->post('auth'));
		if ($user_id = getUserId($key)) 
		{ 
		   $check      = $this->Common->get_details('favourites',array('user_id'=>$user_id));
           if($check->num_rows()>0)
           {  
    		   $favourites = $this->favourites->getFavouriteProducts($user_id);  
    		   foreach($favourites as $fav)
    		   {
    		       $product    = $this->Common->get_details('products',array('p_id'=>$fav->product_id))->row();
    		       $restaurant = $this->Common->get_details('restaurants',array('r_id'=>$fav->r_id))->row();
    		       $fav->product_name = $product->name;
    		       $fav->price        = $product->price;
    		       $fav->product_image= $product->cover_image;
    		       $fav->rest_name    = $restaurant->rest_name;
    		       $fav->rest_image   = $restaurant->cover_image;
    		   }
    		   $return     = [ 
    		                    'status'  => true,
    		                    'message' => 'Success',
    		                    'data'    => $favourites
    		                 ];
           }
           else
           {
               $return     = [ 
    		                    'status'  => false,
    		                    'message' => 'Failed',
    		                    'data'    => array()
    		                 ];
           }
		}		   
		else 
		{
			   $return = [
            				'status'  => false,
            				'message' => 'Session expired, Login again',
            				'data'    => array()
            			];
		}
		print_r(json_encode($return));
	}
	
	public function remove()
	{
		$key = $this->security->xss_clean($this->input->post('auth'));
		if ($user_id = getUserId($key)) 
		{  
		   $fav_id     = $this->security->xss_clean($this->input->post('favourite_id'));
		   $check      = $this->Common->get_details('favourites',array('fav_id'=>$fav_id));
           if($check->num_rows()>0)
           {  
    		   $this->Common->delete('favourites',array('fav_id'=>$fav_id));
    		   $return     = [ 
    		                    'status'  => true,
    		                    'message' => 'Success'
    		                 ];
           }
           else
           {
               $return     = [ 
    		                    'status'  => false,
    		                    'message' => 'Failed'
    		                 ];
           }
		}		   
		else 
		{
			   $return = [
            				'status'  => false,
            				'message' => 'Session expired, Login again'
            			];
		}
		print_r(json_encode($return));
	}
}
?>
