<?php
defined('BASEPATH') OR exit('No direct script access allowed');

class Delivery extends CI_Controller {
	public function __construct()
	{
		parent::__construct();
		$this->load->model('Common');
		$this->load->model('android/M_delivery','delivery');
	}
	
	public function check()
	{
	    $latitude      = $this->security->xss_clean($this->input->post('latitude'));
	    $longitude     = $this->security->xss_clean($this->input->post('longitude'));
	    $restaurant_id = $this->security->xss_clean($this->input->post('restaurant_id'));
	    $branch_id     = $this->security->xss_clean($this->input->post('branch_id'));
	    
	    $radius    = $this->Common->get_details('delivery_area',array())->row()->area_distance;
	    $radius    = $radius/1.609;
	    
	    if($restaurant_id!='')
	    {    
	        if($branch_id=='' || $branch_id=='0')
	        {
	             $shops     = $this->delivery->getShopsDelivery($latitude,$longitude,$radius,$restaurant_id);
	        }
	        else
	        {
	             $shops     = $this->delivery->getShopsBranchDelivery($latitude,$longitude,$radius,$branch_id);
	        }
	    }
	    else
	    {
	        $shops     = $this->delivery->getShops($latitude,$longitude,$radius);
	    }
	    
	   // print_r($shops);
	    
		if ($shops>0) 
		{
	    	$return  = [
        				'status'  => true,
        				'message' => 'Success'
        			  ];
		}
		else
		{
			$return = [
        				'status'  => false,
        				'message' => 'Failed'
        			  ];
		}
		print_r(json_encode($return));
		
	}
	


}
?>
