<?php
defined('BASEPATH') OR exit('No direct script access allowed');

class Checkout extends CI_Controller {
	public function __construct()
	{
			parent::__construct();
			$this->load->model('Common');
			$this->load->model('android/M_orders','order');
	}
	
    public function index()
	{   
	    date_default_timezone_set('Asia/Kolkata');
		$timestamp     = date('Y-m-d H:i:s');
		$date          = date('Y-m-d');
		$time          = date('h:i A');
		
		$key = $this->security->xss_clean($this->input->post('auth'));
		if ($user_id = getUserId($key)) 
		{
            $address_id     = $this->security->xss_clean($this->input->post('address_id'));
            $restaurant_id  = $this->security->xss_clean($this->input->post('restaurant_id'));
        	$payment_method = $this->security->xss_clean($this->input->post('payment_method'));
        	$delivery_notes = $this->security->xss_clean($this->input->post('delivery_notes'));
        	$offer_code     = $this->security->xss_clean($this->input->post('offer_code'));
        	$branch_id      = $this->security->xss_clean($this->input->post('branch_id'));
        	
        	$user_details   = $this->Common->get_details('users',array('user_id'=>$user_id))->row();
        	$fcm            = $user_details->fcm;
        	
    		$details        = $this->order->getCartData($user_id);
    		
    		if(count($details) != 0)
    		{
    		    $cart   = $this->Common->get_details('cart',array('user_id'=>$user_id))->result();
    		    $total  = 0;
    		    foreach($cart as $c)
    		    {
    		        $grand           = $c->total;
    		        $c->extras       = $this->Common->get_details('sub_cart',array('cart_id'=>$c->cart_id))->result();
    		        $sub             =0;
    		        foreach($c->extras as $extra)
    		        {
        		        $sub                 = $sub+$extra->total;
    		        }
    		        $total = $total+$grand+$sub;
    		    }
    		    
        		$order = [
                			'user_id'        => $user_id,
                			'r_id'           => $restaurant_id,
                			'branch_id'      => $branch_id,
                			'total'          => $total,
                			'payment_method' => $payment_method,
                			'address_id'     => $address_id,
                			'status'         => 'pending',
                			'ordered_date'   => date('Y-m-d'),
                			'ordered_time'   => $time,
                			'delivery_notes' => $delivery_notes,
                			'offer_code'     => $offer_code,
                			'timestamp'      => $timestamp
                		];
    
        
        		if ($id = $this->Common->insert('orders',$order)) 
        		{  
        		    $cart   = $this->Common->get_details('cart',array('user_id'=>$user_id))->result();
        		    foreach($cart as $c)
        		    {
        		      $pr_array1  = [
        		                        'order_id'    => $id,
        		                        'product_id'  => $c->product_id,
        		                        'price'       => $c->price,
        		                        'quantity'    => $c->quantity,
        		                        'total'       => $c->total,
        		                        'cart_id'     => $c->cart_id,
        		                        'timestamp'   => date('Y-m-d H:i:s')
        		                    ];
        		        if($this->Common->insert('ordered_products',$pr_array1)) 
        		        {
        		            $c->extras       = $this->Common->get_details('sub_cart',array('cart_id'=>$c->cart_id))->result();
            		        foreach($c->extras as $extra)
            		        {
                		        $pr_array2  = [
                		                        'order_id'    => $id,
                		                        'product_id'  => $extra->product_id,
                		                        'extra_id'    => $extra->extra_id,
                		                        'price'       => $extra->price,
                		                        'quantity'    => $extra->quantity,
                		                        'total'       => $extra->total,
                		                        'cart_id'     => $extra->cart_id,
                		                        'timestamp'   => date('Y-m-d H:i:s')
                		                       ];
                		        $this->Common->insert('ordered_extras',$pr_array2);                 
            		        }
        		        }
        		        
        		        $this->Common->delete('cart',array('cart_id' => $c->cart_id));
                        $this->Common->delete('sub_cart',array('cart_id' => $c->cart_id));
                        
                        
        		    }
        		    
        		    $title = 'Order Placed!...';
                    $body   ='Your order placed succesfully!....';
                    $this->sendNotification($title,$body,$fcm);
                    
                    $not_array = [
                                     'user_id'  => $user_id,
                                     'title'    => $title,
                                     'message'  => $body,
                                     'date'     => date('Y-m-d'),
                                     'time'     => date('h:i A'),
                                     'timestamp'=> date('Y-m-d H:i:s')
                                 ];
        		    $this->Common->insert('notifications',$not_array);
        		    
            		$return = [
            		             'message' => 'success' 
            		          ];
        		}
        		else 
        		{
        			$return = [
        				        'message' => 'failed'
        			          ];
        		}
    		}
            else
            {
                $return = [
                            'message' => 'failed'  
                          ];
            }
		}
		else
		{
			$return = [
        				'status'  => false,
        				'message' => 'Session expired, please try again later',
        				'data'    => array(),
        				'total'   => ''
        			  ];
		}    
        print_r(json_encode($return));
	}
	
	public function checkCoupon()
	{   
	    $date       = date('Y-m-d');
	    $time       = date('H:i:s');
	    $current    = date('Y-m-d H:i:s');
	    
	    $offer_code = $this->security->xss_clean($this->input->post('offer_code'));
	    $total      = $this->security->xss_clean($this->input->post('total'));
	    $check      = $this->Common->get_details('coupons',array('offer_code'=>$offer_code));
	    if($check->num_rows()>0)
	    {
	        $coupon      = $check->row();
	        $percentage  = $coupon->percentage;
	        
	        if($coupon->start_time!='00:00:00')
	        {   
	            $c_start  = $coupon->start_date.' '.$coupon->start_time;
	            if($current>=$c_start)
    	        {
    	            $start_date = true;
    	        }
    	        else
    	        {
    	            $start_date = false;
    	        }
	        }
	        else
	        {
	            if($date>=$coupon->start_date)
    	        {
    	            $start_date  = true;
    	        }
    	        else
    	        {
    	            $start_date  = false;
    	        }
	        }
	        
	        
	        if($coupon->end_time!='00:00:00')
	        {  
	            $c_end  = $coupon->end_date.' '.$coupon->end_time;
    	        if($current<=$c_end)
    	        {
    	            $end_date  = true;
    	        }
    	        else
    	        {
    	            $end_date  = false;
    	        }
	        }
	        else
	        {
	            if($date<=$coupon->end_date)
    	        {
    	            $end_date  = true;
    	        }
    	        else
    	        {
    	            $end_date  = false;
    	        }
	        }
	        
	        if($start_date && $end_date)
	        {  
	            
	            $grand    = $total-$total*$percentage/100;
	            $return   = [
	                           'status'   => true,
	                           'message'  => 'Success',
	                           'total'    => $grand
	                        ];
	        }
	        else
	        {
	            $message    = 'Invalid coupon';
	            
	            $return      = [
	                               'status'   => false,
	                               'message'  => $message,
	                               'total'    => $total
	                           ];
	        }
	    }
	    else
	    {
	        $return = [
	                      'status'   => false,
	                      'message'  => 'Invalid coupon',
	                      'total'    => $total
	                  ];
	    }
	    print_r(json_encode($return));
	}
	
	
	public function sendNotification($title,$body,$fcm)
	{
	    $SERVER_API_KEY = "AAAAKjNFP5M:APA91bG4yMG9c0Y6NGPh2gMQT77gTT9cy-ZenigVrh5RZJfBUxZZZYgynM06KTTFrtxyBoFfjqef2VIfVVFPL-cnhgAgJwbzHWsQvmzShzg9lAXFK8emE6EjVILc99TzYA0f3rrXPgkU";
    	$header = [
    		'Authorization: key='. $SERVER_API_KEY,
    		'Content-Type: Application/json'
    	];
    	$msg = [
    		'title' => $title,
    		'body'  => $body
    	];
    	
    	$notification = [
    		'title'             => $title,
    		'body'              => $body,
    		'content_available' => true
    	];
    	
    	$payload = [
    		'data'         => $msg,
    		'notification' => $notification,
    		'to'           => $fcm,
    		'priority'     => 10
    	];
    	$url = 'https://fcm.googleapis.com/fcm/send';
    
    	$curl = curl_init();
    
    	curl_setopt_array($curl, array(
    		 CURLOPT_URL            => "https://fcm.googleapis.com/fcm/send",
    		 CURLOPT_RETURNTRANSFER => true,
    		 CURLOPT_CUSTOMREQUEST  => "POST",
    		 CURLOPT_POSTFIELDS     => json_encode($payload),
    		 CURLOPT_HTTPHEADER     => $header,
    	));
    
    	$response = curl_exec($curl);
    	$err = curl_error($curl);
    
    	curl_close($curl);
        
        return true;
	}
	
}
