<?php
defined('BASEPATH') OR exit('No direct script access allowed');

class Cart extends CI_Controller {
	public function __construct()
	{
		parent::__construct();
		$this->load->model('Common');
		$this->load->model('android/M_products','products');
	}
	public function getData()
	{
	    $key = $this->security->xss_clean($this->input->post('auth'));
		if ($user_id = getUserId($key)) 
		{
		    $cart   = $this->Common->get_details('cart',array('user_id'=>$user_id))->result();
		    $total  = 0;
		    foreach($cart as $c)
		    {
		        $product         = $this->Common->get_details('products',array('p_id'=>$c->product_id))->row();
		        $restaurant      = $this->Common->get_details('restaurants',array('r_id'=>$product->r_id))->row();
		        $c->restaurant   = $restaurant->rest_name;
		        $c->product_name = $product->name;
		        $c->r_id         = $product->r_id;
		        $c->image        = $product->cover_image;
		        $c->price        = $product->price;
		        $cart_total      = $c->price*$c->quantity;
		        $grand           = $cart_total;
		        $c->extras       = $this->Common->get_details('sub_cart',array('cart_id'=>$c->cart_id))->result();
		        $sub             =0;
		        $extra_single    = 0;
		        foreach($c->extras as $extra)
		        {
		          //  $extra_product       = $this->Common->get_details('products',array('p_id'=>$extra->product_id))->row();
		            $extra_product       = $this->Common->get_details('extras',array('extra_id'=>$extra->extra_id))->row();
    		        $extra->product_name = $extra_product->name;
    		        $extra->price        = $extra_product->price;
    		        $extra->image        = $extra_product->image;
    		        $extra->total        = number_format($extra->price*$extra->quantity,'2');
    		        $sub                 = $sub+$extra->total;
    		        $extra_single        = $extra_single+$extra->price;
		        }
		        $total = $total+$grand+$sub;
		        $c->singl_price=  number_format($c->price+$extra_single,'2');
		        $c->total      =  number_format($cart_total+$sub,'2');
		    }
	    	$return = [
        				'status'  => true,
        				'message' => 'Success',
        				'data'    => $cart,
        				'total'   => number_format($total,'2')
        			  ];
		}
		else
		{
			$return = [
        				'status'  => false,
        				'message' => 'Session expired, please try again later',
        				'data'    => array(),
        				'total'   => ''
        			  ];
		}
		print_r(json_encode($return));
		
	}
	
	public function add()
	{
	    $key = $this->security->xss_clean($this->input->post('auth'));
		if ($user_id = getUserId($key)) 
		{
    		$product_id  = $this->security->xss_clean($this->input->post('product_id'));
    		$quantity    = $this->security->xss_clean($this->input->post('quantity'));
    		$notes       = $this->security->xss_clean($this->input->post('special_request'));
    		$extra_products = $this->security->xss_clean($this->input->post('extras'));
    		$extras      = json_decode($extra_products,true);
    		$branch_id   = $this->security->xss_clean($this->input->post('branch_id'));
            
            $product = $this->Common->get_details('products',array('p_id'=>$product_id))->row();
    	    $price   = $product->price;
    	    $total   = $price*$quantity;

    		$item        = [
            			     'user_id'     => $user_id,
            			     'product_id'  => $product_id
            		       ];
    	    $restaurant_id = $this->Common->get_details('products',array('p_id'=>$product_id))->row()->r_id;
    	    $cart_check    = $this->products->cartCheck($restaurant_id,$user_id);
    	    if($cart_check==0)
    	     {      
    	            
        		    $check   = $this->Common->get_details('cart',$item);
            		if ($check->num_rows() > 0) 
            		{
            			$cart_id = $check->row()->cart_id;
            			if($this->Common->update('cart_id',$cart_id,'cart',array('quantity' => $quantity,'total'=>$total)))
            			{   
            			    $sub_items  = $this->Common->get_details('sub_cart',array('cart_id'=>$cart_id))->result();
            			    foreach($sub_items as $items)
            			    {
            			        $sub_product = $this->Common->get_details('extras',array('extra_id'=>$items->extra_id))->row();
            			        $sub_price   = $sub_product->price;
            			        $sub_total   = $sub_price*$quantity;
            			        $this->Common->update('sb_id',$items->sb_id,'sub_cart',array('quantity' => $quantity,'total'=>$sub_total));
            			    }
            			}
            		}
            		else 
            		{
            			$item['quantity']   = $quantity;
            			$item['notes']      = $notes;
            			$item['price']      = $price;
            			$item['total']      = $total;
            			$item['date']       = date('Y-m-d');
                		$item['time']       = date('h:i A');
                		$item['branch_id']  = $branch_id;
                		$item['r_id']       = $restaurant_id; 
            			if($id=$this->Common->insert('cart',$item))
            			{
            			     $i=0;
            			    foreach($extras as $extra)
            			    {   
            			     //   $s_product = $this->Common->get_details('products',array('p_id'=>$extra))->row();
            			        $s_product = $this->Common->get_details('extras',array('extra_id'=>$extra))->row();
            			        $s_price   = $s_product->price;
            			        $s_total   = $s_price*$quantity;
                			    $array     = [
                    			               'cart_id'    => $id,
                    			               'product_id' => $product_id,
                    			               'extra_id'   => $extra,
                    			               'quantity'   => $quantity,
                    			               'price'      => $s_price,
                    			               'total'      => $s_total,
                    					       'timestamp'  => date('Y-m-d H:i:s')
                			                 ];
                			   $this->Common->insert('sub_cart',$array);   
                			   $i++;
            			    }            
            			}
            		} 
            		
            	    $return = [
            	                'status'  => true,
            			        'message' => 'success'
            		          ];	
    	     }
    	     else
    	     {
    	         $return   = [
            	                'status'  => false,
            			        'message' => 'Failed'
            		          ];	
    	     }
		}
		else
		{
			$return = [
        				'status' => false,
        				'message' => 'Session expired, please try again later'
        			  ];
		}
		print_r(json_encode($return));
	}
	
	public function deleteCartData()
	{   
	    $key = $this->security->xss_clean($this->input->post('auth'));
		if ($user_id = getUserId($key)) 
		{
    	    $cart_id = $this->security->xss_clean($this->input->post('cart_id'));
    	    if($this->Common->delete('cart',array('cart_id' => $cart_id)))
    	    {
    	        $this->Common->delete('sub_cart',array('cart_id' => $cart_id));
    	        
    	        $cart   = $this->Common->get_details('cart',array('user_id'=>$user_id))->result();
    		    $total  = 0;
    		    foreach($cart as $c)
    		    {
    		        $product         = $this->Common->get_details('products',array('p_id'=>$c->product_id))->row();
    		        $c->product_name = $product->name;
    		        $c->image        = $product->cover_image;
    		        $c->price        = $product->price;
    		        $c->total        = number_format($c->price*$c->quantity,'2');
    		        $grand           = $c->total;
    		        $c->extras       = $this->Common->get_details('sub_cart',array('cart_id'=>$c->cart_id))->result();
    		        $sub             =0;
    		        foreach($c->extras as $extra)
    		        {
    		          //  $extra_product       = $this->Common->get_details('products',array('p_id'=>$extra->product_id))->row();
    		            $extra_product       = $this->Common->get_details('extras',array('extra_id'=>$extra->extra_id))->row();
        		        $extra->product_name = $extra_product->name;
        		        $extra->price        = $extra_product->price;
        		      //  $extra->image        = $this->products->getProductImage($extra->product_id);
        		        $extra->image        = $extra_product->image;
        		        $extra->total        = number_format($extra->price*$extra->quantity,'2');
        		        $sub                 = $sub+$extra->total;
    		        }
    		        $total = $total+$grand+$sub;
    		    }
    	        
    	        $return = [
    	          'message' => 'success',
    	          'total'   => number_format($total,'2')
    	        ];
    	    }
    	    else
    	    {
    	        $return = [
    	          'message' => 'failed',
    	          'total'   => '0'
    	        ];
    	    }
		}
		else
		{
			$return = [
        				'status' => false,
        				'message' => 'Session expired, please try again later'
        			  ];
		}  
	    print_r(json_encode($return));
	}
	
	public function updateCart()
	{
	    $key = $this->security->xss_clean($this->input->post('auth'));
		if ($user_id = getUserId($key)) 
		{
    		$cart_id     = $this->security->xss_clean($this->input->post('cart_id'));
    		$quantity    = $this->security->xss_clean($this->input->post('quantity'));
    		
            $cart_data   = $this->Common->get_details('cart',array('cart_id'=>$cart_id))->row();
            $product_id  = $cart_data->product_id;
            $product     = $this->Common->get_details('products',array('p_id'=>$product_id))->row();
    	    $price       = $product->price;
    	    $total       = $price*$quantity; 
    	    
    		$array = [
            			'quantity' => $quantity,
            			'total'    => $total
            	 	];
    
    		if ($this->Common->update('cart_id',$cart_id,'cart',$array)) 
    		{   
    		  //  $this->Common->update('cart_id',$cart_id,'sub_cart',$array);
    		    
    		    $sub_items  = $this->Common->get_details('sub_cart',array('cart_id'=>$cart_id))->result();
			    foreach($sub_items as $items)
			    {
			        $sub_product = $this->Common->get_details('extras',array('extra_id'=>$items->extra_id))->row();
			        $sub_price   = $sub_product->price;
			        $sub_total   = $sub_price*$quantity;
			        $this->Common->update('sb_id',$items->sb_id,'sub_cart',array('quantity' => $quantity,'total'=>$sub_total));
			    }
    		    
    		    $cart   = $this->Common->get_details('cart',array('user_id'=>$user_id))->result();
    		    $total  = 0;
    		    foreach($cart as $c)
    		    {
    		        $product         = $this->Common->get_details('products',array('p_id'=>$c->product_id))->row();
    		        $c->product_name = $product->name;
    		        $c->r_id         = $product->r_id;
    		        $c->image        = $product->cover_image;
    		        $c->price        = $product->price;
    		        $cart_total      = number_format($c->price*$c->quantity,'2');
    		        $grand           = $c->total;
    		        $c->extras       = $this->Common->get_details('sub_cart',array('cart_id'=>$c->cart_id))->result();
    		        $sub             = 0;
    		        $extra_single    = 0;
    		        foreach($c->extras as $extra)
    		        {
    		          //  $extra_product       = $this->Common->get_details('products',array('p_id'=>$extra->product_id))->row();
    		            $extra_product       = $this->Common->get_details('extras',array('extra_id'=>$extra->extra_id))->row();
        		        $extra->product_name = $extra_product->name;
        		        $extra->price        = $extra_product->price;
        		      //  $extra->image        = $this->products->getProductImage($extra->product_id);
        		        $extra->image        = $extra_product->image;
        		        $extra->total        = number_format($extra->price*$extra->quantity,'2');
        		        $sub                 = $sub+$extra->total;
        		        $extra_single        = $extra_single+$extra->price;
    		        }
    		        $total = $total+$grand+$sub;
    		        $c->total      =  number_format($cart_total+$sub,'2');
    		        $c->singl_price=  number_format($c->price+$extra_single,'2');
    		    }
    		    
    			$return = [
            				'message' => 'success',
            				'data'    => $cart,
            				'total'   => number_format($total,'2')
    		         	 ];
    		}
    		else 
    		{
    			$return = [
    			        	'message' => 'failed',
    			        	'data'    => array(),
    			        	'total'   => ''
    			          ];
    		}
		}
		else
		{
			$return = [
        				'status' => false,
        				'message' => 'Session expired, please try again later'
        			  ];
		}  
		print_r(json_encode($return));
	}
	
    public function checkCart()
	{
	    $key = $this->security->xss_clean($this->input->post('auth'));
		if ($user_id = getUserId($key)) 
		{    
		     $restaurant_id = $this->input->post('restuarant_id');
		     $branch_id     = $this->input->post('branch_id');
		     $cart_check    = $this->products->restaurantCartCheck($restaurant_id,$user_id,$branch_id);
    	     if($cart_check==0)
    	     {
    	         $return  = [
    	                        'status' => false,
    	                        'count'  => $cart_check,
    	                        'total'  => '0',
    	                        'message'=> 'Failed'
    	                    ];
    	     }
    	     else
    	     {   
    	        $cart   = $this->Common->get_details('cart',array('user_id'=>$user_id))->result();
    		    $total  = 0;
    		    foreach($cart as $c)
    		    {
    		        $product         = $this->Common->get_details('products',array('p_id'=>$c->product_id))->row();
    		        $c->price        = $product->price;
    		        $c->total        = $c->price*$c->quantity;
    		        $grand           = $c->total;
    		        $c->extras       = $this->Common->get_details('sub_cart',array('cart_id'=>$c->cart_id))->result();
    		        $sub             =0;
    		        foreach($c->extras as $extra)
    		        {
    		          //  $extra_product       = $this->Common->get_details('products',array('p_id'=>$extra->product_id))->row();
    		            $extra_product       = $this->Common->get_details('extras',array('extra_id'=>$extra->extra_id))->row();
        		        $extra->price        = $extra_product->price;
        		        $extra->total        = $extra->price*$extra->quantity;
        		        $sub                 = $sub+$extra->total;
    		        }
    		        $total = $total+$grand+$sub;
    		    }
    	         
    	         $return  = [
    	                        'status' => true,
    	                        'count'  => $cart_check,
    	                        'total'  => number_format($total,'2'),
    	                        'message'=> 'Success'
    	                    ];
    	     }
		}
		else
		{
			$return = [
        				'status' => false,
        				'message' => 'Session expired, please try again later'
        			  ];
		}  
	    print_r(json_encode($return));
	}
	
	public function delete()
	{   
	    $key = $this->security->xss_clean($this->input->post('auth'));
		if ($user_id = getUserId($key)) 
		{   
		    $cart = $this->Common->get_details('cart',array('user_id'=>$user_id))->result();
		    foreach($cart as $c)
		    {   
		        $cart_id = $c->cart_id;
		        if($this->Common->delete('cart',array('cart_id' => $cart_id)))
        	    {
        	        $this->Common->delete('sub_cart',array('cart_id' => $cart_id));
        	    }
		    }
		     $return   = [
		                  'status'  => true,
            	          'message' => 'success'  
            	         ];
		}
		else
		{
			$return = [
        				'status'  => false,
        				'message' => 'Session expired, please try again later'
        			  ];
		}  
	    print_r(json_encode($return));
	}
	
	public function getCount()
	{
	    $key = $this->security->xss_clean($this->input->post('auth'));
		if ($user_id = getUserId($key)) 
		{
		    $cart   = $this->Common->get_details('cart',array('user_id'=>$user_id));
		    if($cart->num_rows()>0)
		    {
		        $count  = $cart->num_rows();
		        $return = [
            				'status'  => true,
            				'message' => 'Success',
            				'data'    => $count
            			 ];
		    }
		    else
		    {
		        $return = [
            				'status'  => false,
            				'message' => 'Failed',
            				'data'    => '0'
            			  ];
		    }
		}
		else
		{
			$return = [
        				'status'  => false,
        				'message' => 'Session expired, please try again later',
        				'data'    => '0'
        			  ];
		}
		print_r(json_encode($return));
		
	}
	
	
}
?>
