<?php
defined('BASEPATH') OR exit('No direct script access allowed');

class Address extends CI_Controller {
	public function __construct()
	{
		parent::__construct();
		$this->load->model('Common');
		$this->load->model('android/M_address','address');
	}
	public function index()
	{
	    $key = $this->security->xss_clean($this->input->post('auth'));
		if ($user_id = getUserId($key)) 
		{
		    $address = $this->address->getAddress($user_id);
	    	$return  = [
        				'status'  => true,
        				'message' => 'Success',
        				'data'    => $address
        			  ];
		}
		else
		{
			$return = [
        				'status'  => false,
        				'message' => 'Session expired, please try again later',
        				'data'    => array()
        			  ];
		}
		print_r(json_encode($return));
		
	}
	
	public function add()
	{
	    $key = $this->security->xss_clean($this->input->post('auth'));
		if ($user_id = getUserId($key)) 
		{
    		$area      = $this->security->xss_clean($this->input->post('area'));
    		$nick_name = $this->security->xss_clean($this->input->post('nick_name'));
    		$type      = $this->security->xss_clean($this->input->post('type'));
    		$street    = $this->security->xss_clean($this->input->post('street'));
    		$building  = $this->security->xss_clean($this->input->post('building'));
    		$floor     = $this->security->xss_clean($this->input->post('floor'));
    		$apartment = $this->security->xss_clean($this->input->post('apartment'));
    		$directions= $this->security->xss_clean($this->input->post('directions'));
    		$mobile    = $this->security->xss_clean($this->input->post('mobile'));
    		$landphone = $this->security->xss_clean($this->input->post('landphone'));
    		$latitude  = $this->security->xss_clean($this->input->post('latitude'));
    		$longiude  = $this->security->xss_clean($this->input->post('longitude'));
    		
            
    		$array     = [
            			     'user_id'    => $user_id,
            			     'area'       => $area,
            			     'nick_name'  => $nick_name,
            			     'type'       => $type,
            			     'street'     => $street,
            			     'building'   => $building,
            			     'floor'      => $floor,
            			     'apartment'  => $apartment,
            			     'directions' => $directions,
            			     'mobile'     => $mobile,
            			     'landphone'  => $landphone,
            			     'latitude'   => $latitude,
            			     'longitude'  => $longiude,
            			     'date'       => date('Y-m-d'),
            			     'timestamp'  => date('Y-m-d H:i:s')
            		       ];
    	    
             if($id=$this->Common->insert('address',$array))
             {
            	    $return = [
            	                'status'  => true,
            			        'message' => 'success',
            			        'data'    => [
            			                        'address_id' => $id
            			                     ]
            		          ];	
    	     }
    	     else
    	     {
    	         $return   = [
            	                'status'  => false,
            			        'message' => 'Failed',
            			        'data'    => array()
            		          ];	
    	     }
		}
		else
		{
			$return = [
        				'status'  => false,
        				'message' => 'Session expired, please try again later',
        				'data'    => array()
        			  ];
		}
		print_r(json_encode($return));
	}
	
	public function deleteAddress()
	{   
	    $key = $this->security->xss_clean($this->input->post('auth'));
		if ($user_id = getUserId($key)) 
		{
    	    $address_id = $this->security->xss_clean($this->input->post('address_id'));
    	    if($this->Common->update('address_id',$address_id,'address',array('status' => '0')))
    	    {
    	        $return  =  [
    	                      'status'  => true,
                	          'message' => 'success'  
                	        ];
    	    }
    	    else
    	    {
    	        $return   = [  
    	                      'status'  => false,
                	          'message' => 'failed'  
                	        ];
    	    }
		}
		else
		{
			$return = [
        				'status' => false,
        				'message' => 'Session expired, please try again later'
        			  ];
		}  
	    print_r(json_encode($return));
	}
	
	public function updateAddress()
	{
	    $key = $this->security->xss_clean($this->input->post('auth'));
		if ($user_id = getUserId($key)) 
		{   
		    $address_id= $this->security->xss_clean($this->input->post('address_id'));
    		$area      = $this->security->xss_clean($this->input->post('area'));
    		$nick_name = $this->security->xss_clean($this->input->post('nick_name'));
    		$type      = $this->security->xss_clean($this->input->post('type'));
    		$street    = $this->security->xss_clean($this->input->post('street'));
    		$building  = $this->security->xss_clean($this->input->post('building'));
    		$floor     = $this->security->xss_clean($this->input->post('floor'));
    		$apartment = $this->security->xss_clean($this->input->post('apartment'));
    		$directions= $this->security->xss_clean($this->input->post('directions'));
    		$mobile    = $this->security->xss_clean($this->input->post('mobile'));
    		$landphone = $this->security->xss_clean($this->input->post('landphone'));
    		$latitude  = $this->security->xss_clean($this->input->post('latitude'));
    		$longiude  = $this->security->xss_clean($this->input->post('longitude'));
    		
            
    		$array     = [
            			     'user_id'    => $user_id,
            			     'area'       => $area,
            			     'nick_name'  => $nick_name,
            			     'type'       => $type,
            			     'street'     => $street,
            			     'building'   => $building,
            			     'floor'      => $floor,
            			     'apartment'  => $apartment,
            			     'directions' => $directions,
            			     'mobile'     => $mobile,
            			     'landphone'  => $landphone,
            			     'latitude'   => $latitude,
            			     'longitude'  => $longiude
            		       ];
    	    
             if($id=$this->Common->update('address_id',$address_id,'address',$array))
             {
            	    $return = [
            	                'status'  => true,
            			        'message' => 'success'
            		          ];	
    	     }
    	     else
    	     {
    	         $return   = [
            	                'status'  => false,
            			        'message' => 'Failed'
            		          ];	
    	     }
		}
		else
		{
			$return = [
        				'status'  => false,
        				'message' => 'Session expired, please try again later',
        				'data'    => array()
        			  ];
		}
		print_r(json_encode($return));
	}
	
	public function checkDeliveryAddress()
	{
	    $key = $this->security->xss_clean($this->input->post('auth'));
		if ($user_id = getUserId($key)) 
		{ 
		    $restaurant_id = $this->security->xss_clean($this->input->post('restaurant_id'));
		    $branch_id     = $this->security->xss_clean($this->input->post('branch_id'));
		    $address_check = $this->Common->get_details('address',array('user_id'=>$user_id));
		    $radius        = $this->Common->get_details('delivery_area',array())->row()->area_distance;
	        $radius        = $radius/1.609;
	        
		    if($address_check->num_rows()>0)
		    {
		       $address       = $this->address->getAddress($user_id);
		       $count         = '0';
		       foreach($address as $addr)
		       {
		           $latitude  = $addr->latitude;
		           $longitude = $addr->longitude;
		           
		           if($branch_id!='' || $branch_id!='0')
		           {
		               $shops     = $this->address->getShopsBranchDelivery($latitude,$longitude,$radius,$branch_id);
		           }
		           else
		           {
		               $shops     = $this->address->getShopsDelivery($latitude,$longitude,$radius,$restaurant_id);
		           }
		           $count     = $count+$shops;
		       }
		      // print_r($count);
		       if($count>0)
		       {
		           $restaurant  = $this->Common->get_details('restaurants',array('r_id'=>$restaurant_id))->row();
		           $r_latitude  = $restaurant->latitude;
		           $r_longitude = $restaurant->longitude;
		           $d_address   = $this->address->getDeliveryAddress($r_latitude,$r_longitude,$radius,$user_id);
		           $return      = [
		                            'status'   => true,
		                            'message'  => 'Success',
		                            'data'     => $d_address
		                          ];
		       }
		       else
		       {
		           $return = [
                				'status'  => false,
                				'message' => 'Failed',
                				'data'    => array()
                			  ];
		       }
		    }
            else
            {
                	$return = [
                				'status'  => false,
                				'message' => 'Failed',
                				'data'    => array()
                			  ];
            }
		}
		else
		{
			$return = [
        				'status'  => false,
        				'message' => 'Session expired, please try again later',
        				'data'    => array()
        			  ];
		}
		print_r(json_encode($return));
	}
	
}
?>
